// QSvr0.cpp : Implementation of WinMain


#include "stdafx.h"
#include "resource.h"
#include "QSvr0_i.h"

#include <stdio.h>

using namespace DSLib;

class CQSvr0Module : public ATL::CAtlServiceModuleT< CQSvr0Module, IDS_SERVICENAME >
{
public:
	typedef ATL::CAtlServiceModuleT<CQSvr0Module, IDS_SERVICENAME> _parent_t;

	DECLARE_LIBID(LIBID_QSvr0Lib)
	DECLARE_REGISTRY_APPID_RESOURCEID(IDR_QSVR0, "{335C1048-796F-4219-B269-9D308485D262}")
	HRESULT InitializeSecurity() throw()
	{
		// TODO : Call CoInitializeSecurity and provide the appropriate security settings for your service
		// Suggested - PKT Level Authentication, 
		// Impersonation Level of RPC_C_IMP_LEVEL_IDENTIFY 
		// and an appropiate Non NULL Security Descriptor.

		return S_OK;
	}

	void ServiceMain( 
		DWORD dwArgc, 
		LPTSTR* lpszArgv  
		) 
	{
		_TRACE_THIS();

		mDeviceHandle = NULL;
		mFrameNumber = 0;

		_parent_t::ServiceMain(dwArgc, lpszArgv);
	}

	PVOID mDeviceHandle;
	int mFrameNumber;

	static QRETURN QCAP_EXPORT _FormatChanged( PVOID pDevice /*IN*/, ULONG nVideoInput /*IN*/, ULONG nAudioInput /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, BOOL bVideoIsInterleaved /*IN*/, double dVideoFrameRate /*IN*/, ULONG nAudioChannels /*IN*/, ULONG nAudioBitsPerSample /*IN*/, ULONG nAudioSampleFrequency /*IN*/, PVOID pUserData /*IN*/ )
	{
		_TRACE_FUNC0(nVideoInput << ',' << nAudioInput << ',' << nVideoWidth << ',' << nVideoHeight << ',' << bVideoIsInterleaved << ',' << dVideoFrameRate << ',' << nAudioChannels << ',' << nAudioBitsPerSample << ',' << nAudioSampleFrequency);

		return QCAP_RT_OK;
	}

	static QRETURN QCAP_EXPORT _VideoPreview( PVOID pDevice /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ )
	{
		CQSvr0Module* pThis = (CQSvr0Module*)pUserData;

		return pThis->VideoPreview(pDevice /*IN*/, dSampleTime /*IN*/, pFrameBuffer /*IN*/, nFrameBufferLen);
	}

	QRETURN VideoPreview( PVOID pDevice /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/)
	{
		_TRACE_THIS();

		if(mFrameNumber++ == 0)
		{
			QRESULT qres = QCAP_SET_VIDEO_RECORD_PROPERTY(mDeviceHandle, 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, 
				QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF);
			_TRACE(_T("qres=") << qres << std::endl);

			qres = QCAP_SET_AUDIO_RECORD_PROPERTY(mDeviceHandle, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC);
			_TRACE(_T("qres=") << qres << std::endl);

			qres = QCAP_START_RECORD(mDeviceHandle, 0, "C:\\record.mp4");
			_TRACE(_T("qres=") << qres << std::endl);
		}

		return QCAP_RT_OK;
	}

	HRESULT PreMessageLoop(_In_ int nShowCmd) throw()
	{
		_TRACE_THIS();

		HRESULT hr = _parent_t::PreMessageLoop(nShowCmd);
		if(FAILED(hr)) return hr;

		QRESULT qres = QCAP_CREATE("QP0203 PCI", 0, NULL, &mDeviceHandle);
		_TRACE(_T("qres=") << qres << std::endl);
		if(qres == QCAP_RS_SUCCESSFUL)
		{
			QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( mDeviceHandle, 0,QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF, 0, 0);


			QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(mDeviceHandle, _FormatChanged, this);
			QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(mDeviceHandle, _VideoPreview, this);

			QCAP_RUN(mDeviceHandle);
		}

		return hr;
	}

	HRESULT PostMessageLoop() throw()
	{
		_TRACE_THIS();

		if(mDeviceHandle)
		{
			QCAP_DESTROY(mDeviceHandle);
			mDeviceHandle = NULL;
		}

		return _parent_t::PostMessageLoop();
	}
};

CQSvr0Module _AtlModule;

//
extern "C" int WINAPI _tWinMain(HINSTANCE /*hInstance*/, HINSTANCE /*hPrevInstance*/, 
	LPTSTR /*lpCmdLine*/, int nShowCmd)
{
	_TRACE_FUNC();

	return _AtlModule.WinMain(nShowCmd);
}

